import java.util.*;
import java.rmi.*;
import java.rmi.server.UnicastRemoteObject;

/** RMI intermediary between the SQLWrapper and Client Applet to report Errors. 
ErrorSnitch follows the SQLWrapper through it's methods, adding any parsing 
(or other) errors to a Vector of "knownErrors" to return to the Client.*/
public class ErrorSnitch extends UnicastRemoteObject implements Snitch
{
  private Vector knownErrors;

  public ErrorSnitch()throws RemoteException
  {
    knownErrors = new Vector();
  }
  
  /** Adds error to Vector of known errors*/
  public void reportError(String error) throws RemoteException
  {
    knownErrors.addElement(error);
  }
  
  /** Returns Vector of known errors */
  public Vector getErrors() throws RemoteException
  {
    return knownErrors;
  }
  
}
