//The Client Applet
//import java.applet.*;
import java.awt.*;
import java.awt.event.*;
import java.rmi.*;
import java.net.*;
import java.net.UnknownHostException;
import java.util.Vector;
import java.io.*;
import java.lang.*;
import java.util.*;
import netscape.javascript.*;
import com.sun.java.swing.table.*;
import com.sun.java.swing.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.preview.*;
/** GUI for the SQL Wrapper*/

class CustomModel extends DefaultTableModel implements java.io.Serializable{
            CustomModel(Object [][] data, Object[] columnIdentifiers){
                super(data, columnIdentifiers);
            }
            public Class getColumnClass(int col){
                Vector v = (Vector)dataVector.elementAt(0);
                return v.elementAt(col).getClass();
            }
            public boolean isCellEditable(int row, int col){
                Class columnClass = getColumnClass(col);
                return columnClass != URL.class;
            }
            public int getColPrefWidth(JTable ResultTable, int indexOfCol){
                TableColumn Col = ResultTable.getColumn(columnIdentifiers.elementAt(indexOfCol));
               //Get Column Header Width hw
                TableCellRenderer renderH = Col.getHeaderRenderer();
                Component compH = renderH.getTableCellRendererComponent(ResultTable, 
                                                 Col.getHeaderValue(), false, false, 0, 0);
                int hw = compH.getPreferredSize().width + 4;
                //Get Widest Column maxCw 
                 int w = 0; int maxCw = 0;
                  for (int r=0; r<this.getRowCount(); r++){
                  TableCellRenderer renderC = ResultTable.getDefaultRenderer(Col.getClass());
                  Component compC = renderC.getTableCellRendererComponent
                                                 (ResultTable, ResultTable.getValueAt(r,indexOfCol),
                                                    false, false, r, indexOfCol);
                  w = compC.getPreferredSize().width;
                  maxCw = w > maxCw ? w : maxCw;
                  }
                  //hw = hw > maxCw ? hw : maxCw;
                  //int numRows = 1;
                  //if hw
                  return hw > maxCw ? hw : maxCw;
            }
            }


public class QueryApplet extends JApplet implements Runnable{

JMenuItem New, Open, Save, Delete, Exit, SQLHelp, doubleCheck;
JTextArea query_text;
JPanel p; 
JMenuItem toSelected;
JTextField status;
QueryInterface QInterface;
JFrame OpenFrame;
JFrame f;
JList QueryList;
URL SelectedURL;

boolean DeleteMode = false;
String cookie;

Object toSend;

  class URLRenderer extends JLabel implements TableCellRenderer{
            public URLRenderer(){
                super();
            setOpaque(true);}
            
            public java.awt.Component getTableCellRendererComponent(JTable table,
                                               java.lang.Object value,
                                               boolean isSelected,
                                               boolean hasFocus,
                                               int row,
                                               int column){
        if (value != null) setText(value.toString());
        else setText("");
         if (isSelected)
        { if (value != null){
            SelectedURL = (URL)value;
            toSelected.setEnabled(true);}
            else
            {toSelected.setEnabled(false);}
            
            setForeground(table.getSelectionForeground());
            setBackground(table.getSelectionBackground());
            }
        else{ setForeground(table.getForeground());
              setBackground(table.getBackground());
              toSelected.setEnabled(false);
              }
       
       return this;
                     }
        }


  class SymAction implements java.awt.event.ActionListener
	  {
	    public void actionPerformed(java.awt.event.ActionEvent event)
        {
    	Object object = event.getSource();
		if (object == Open)
		    Open_Action(event);
        else if (object == New)
            New_Action(event);
        else if (object == Save)
            Save_Action(event);
        else if (object == Delete)
        	Delete_Action(event);
        else if (object == SQLHelp)
        	SQLHelp_Action(event);
        else if (object == Exit)
        	Exit_Action(event);
        else if (object == toSelected)
		    URL_Action();
        }
      }

     

  /**Uses showDocument(URL) of the Applet Context class to hyperlink to the selected URL*/
public void URL_Action(){
    getAppletContext().showDocument(SelectedURL);
    f.dispose();}

public void addLinkMenu(){
            JMenuBar LinkMenu = new JMenuBar();
            JMenu Link = new JMenu("Link");
            toSelected = new JMenuItem("to Selected..");
            toSelected.setEnabled(false);       
            SymAction lSymAction = new SymAction();
            toSelected.addActionListener(lSymAction);
                   
            Link.add(toSelected);
            LinkMenu.add(Link);
            
            p.add(LinkMenu, "North");
            
       }

/**Sets & returns the client cookie. Uses the JSObject to call Javascript functions setCookie, etc.  */
public String makeCookie(JSObject win){
              
             String time = (String) win.call("returnTime", null);
             int begin = time.indexOf(',') + 1;
             time = time.substring(begin, time.length());
             time = time.replace(' ', '_');
             time = time.replace(':', '_');
             time = cookie + time;
             Object [] Args = {"client", time , new Integer(30)};
             win.call("setCookie", Args);
             Object [] Arg = {"client"};
             return (String) win.call("getCookie", Arg);
}
/** Initializes the GUI. Assigns a cookie (the local host), 
*   retrieves a copy of the RMI query interface, 
*   draws the GUI components, and defines a convenience class which forwards 
*   component ActionEvents to the methods which handle them*/
public void init(){
        
         GridBagLayout gridbag = new GridBagLayout();
         GridBagConstraints c = new GridBagConstraints();
         setFont(new Font("Helvetica", Font.PLAIN, 14));
         getContentPane().setLayout(gridbag);
         c.fill = GridBagConstraints.BOTH;
         c.weightx = 1.0;
         
         JMenuBar mainMenuBar = new JMenuBar();
         JMenu menu1, menu3;

        menu1 = new JMenu("File");
            New = new JMenuItem("New");
                menu1.add(New);
            Open = new JMenuItem("Open...");
                menu1.add(Open);
            Save = new JMenuItem("Save...");
                menu1.add(Save);
            Delete = new JMenuItem("Delete...");
                menu1.add(Delete);
                menu1.addSeparator();
            Exit = new JMenuItem("Exit");
                menu1.add(Exit);
        mainMenuBar.add(menu1);

        menu3 = new JMenu("Help");
            SQLHelp = new JMenuItem("Using SQL..");
                menu3.add(SQLHelp);
        mainMenuBar.add(menu3);
       
        c.insets = new Insets(10, 10, 0, 100);
        c.gridwidth = GridBagConstraints.REMAINDER; //end row
        gridbag.setConstraints(mainMenuBar, c);
        
        getContentPane().add(mainMenuBar);
        
        c.insets = new Insets(0,0,0,0);
        c.gridwidth = GridBagConstraints.REMAINDER; //end row
      
        JPanel pC = new JPanel();
	    pC.setLayout(new BorderLayout());
	    JLabel EnterQuery = new JLabel("Enter SQL Query & Press Submit:");
	    pC.add(EnterQuery, "North");
	    String exampleQuery = "select * from author \n where name like '%Rundensteiner%';";
	    query_text = new JTextArea(exampleQuery);
	    query_text.setRows(9);
	    query_text.setLineWrap(true);
	    query_text.setWrapStyleWord(true);
	    pC.add(new JScrollPane(query_text), "Center");
	    
	    
	    JButton submit = new JButton("submit");
	    submit.addActionListener(new ActionListener()
	    {  public void actionPerformed(ActionEvent e)
             { submit_server();} });
        
        JPanel pB = new JPanel();
	    pB.add(submit);
	    
	    c.insets = new Insets(5, 30, 5, 30);
	    pB.add(submit, c);
        
        pC.add(pB, "South");
        
        c.insets = new Insets(20,30,5,30);
        getContentPane().add(pC, c);
	    
	    c.insets = new Insets(5, 10, 5, 10);
	    JPanel pS = new JPanel();
	    JLabel state = new JLabel("Status: ");
	    status = new JTextField("Ready", 20);
	    status.setEditable(false);
	    pS.add(state);
	    pS.add(status);
	    c.insets = new Insets(5,10,10,10);
	    this.getContentPane().add(pS, c);

        try {cookie = InetAddress.getLocalHost().toString();}
    	    catch(UnknownHostException uhe){cookie = "Unknown Host";}
        if ( cookie.indexOf("/") != -1 )
	        
	         cookie = cookie.substring(0, cookie.indexOf('/'));
		  
		try {QInterface = (QueryInterface)Naming.lookup("//" +
				           this.getCodeBase().getHost() + "/QueryServer");}
            catch (Exception e) {
			System.out.println("Problem in QueryApplet initialization: " + e.getMessage());
			}
        
        JSObject win = JSObject.getWindow(this);
        JSObject doc = (JSObject) win.getMember("document");
        Object [] Arg = {"client"};
        String ClientCookie = (String) win.call("getCookie", Arg);			
        
        if (ClientCookie == null){//Netscape
            cookie = makeCookie(win);}
        else if (ClientCookie.equals("undefined"))//Internet Explorer
           { cookie = makeCookie(win);}
       else {cookie = ClientCookie;}

        
       toSend = new Vector();

      
     SymAction lSymAction = new SymAction();
        New.addActionListener(lSymAction);
        Open.addActionListener(lSymAction);
        Save.addActionListener(lSymAction);
        Delete.addActionListener(lSymAction);
        SQLHelp.addActionListener(lSymAction);
        Exit.addActionListener(lSymAction);
        System.out.println("init finished");
      }
 
    /** Retrieves Client's Saved Queries. Queries are retrieved using
     *  RMI and returned as a List inside a new Frame. If the frame 
     *  was opened specifically for deletion, multiple selection is 
     *  possible. (Deletion of a single selection is 
     *  possible regardless from the frame's menu bar. */
  public void Open_Action(java.awt.event.ActionEvent event)
    {
        OpenFrame = new JFrame();
        try{QueryList = new JList(QInterface.getSavedList(cookie));}
        catch(Exception e){System.out.println("Error getting list from server: " + e);}
        if (!DeleteMode)
            {QueryList.setSelectionMode(ListSelectionModel.SINGLE_SELECTION);}
        OpenFrame.getContentPane().setLayout(new BorderLayout());
        JMenuBar mbar = new JMenuBar();
        JMenu m = new JMenu("Delete");
        doubleCheck = new JMenuItem("Really Delete Selected Items?");
        doubleCheck.setEnabled(false);
        QueryList.addListSelectionListener(new ListSelectionListener(){
            public void valueChanged(ListSelectionEvent e){
                doubleCheck.setEnabled(true);
                QuerySelected_Action();
            }
        });
        doubleCheck.addActionListener(new ActionListener()
	   {  public void actionPerformed(ActionEvent e)
             {  Vector SparedItems = new Vector();
                int size = QueryList.getModel().getSize();
                for (int i = 0; i<size; i++)
                    if (!QueryList.isSelectedIndex(i))
                        SparedItems.addElement(QueryList.getModel().getElementAt(i));
                try{ status.setText(QInterface.deleteFunction(cookie, SparedItems));}
                catch (Exception ex){query_text.setText("Delete problem: "+ ex);}
                OpenFrame.dispose();
                DeleteMode = false;
                 }});

        m.add(doubleCheck);
        mbar.add(m);
        OpenFrame.getContentPane().add(mbar, "North");
        OpenFrame.getContentPane().add(new JScrollPane(QueryList), "Center");
		OpenFrame.setBounds(450, 300, 250, 150);
		OpenFrame.setTitle("Saved Queries");
		OpenFrame.show();
		
    }
    
    /** Prints the Selected Values to the Text Area.*/
    public void QuerySelected_Action(){
        Object [] selected = QueryList.getSelectedValues();
        query_text.setText("");
        for (int i = 0; i< selected.length; i++)
            query_text.append((String)selected[i]);    
    }
    
    /** Clears the Text Area.*/
    public void New_Action(java.awt.event.ActionEvent event)
    {
        query_text.setText("");
        status.setText("");
    }
    
    /** Saves Query currently in the Text Area. Passes the query 
    *   to the Server using RMI where it is saved in a text file named 
    *   with the client's cookie. */
    public void Save_Action(java.awt.event.ActionEvent event)
    {  
        String toSave = query_text.getText();

        try{status.setText("" + QInterface.saveToList(cookie, toSave));}
        catch(Exception e){System.out.println("Save action err: " + e);}
    }
    
    /** Opens Client's Query List for Deletion. This is simply a call 
    *   to the Open_Action method in deletion mode.*/
    public void Delete_Action(java.awt.event.ActionEvent event)
    {
        DeleteMode = true;
        Open_Action(event);
    }
    
    /**Hyperlinks to a web page with an SQL tutorial*/
    public void SQLHelp_Action(java.awt.event.ActionEvent event)
    {
        URL BasicSQL = null;
        try{ 
        getAppletContext().showDocument(new URL("http://willcam.com/sql/sql_001a.htm"));}
        catch (Exception e){status.setText(e + "Sorry. SQL Link Down..");}
    }
    /**Hyperlinks back to the DSRG Homepage*/ 
    public void Exit_Action(java.awt.event.ActionEvent event)
    {   URL exitTo = null;
        try{ 
        getAppletContext().showDocument(new URL("http://davis.wpi.edu/dsrg/index.html"));}
        catch (Exception e){status.setText(e + "Sorry. Just can't leave the applet..");}
    }

    /** Starts Thread to Query Server. Method captures the SQL query 
    *   currently showing in the Text area and disposes of the "Open" frame
    *   if it hasn't been already.*/
	public void submit_server(){
        if (OpenFrame != null)
            OpenFrame.dispose();
	    toSend = query_text.getText();
	    
	    status.setText("Submit request initializing..");
	    
	    Thread clientThread = new Thread (this);
	        clientThread.start();
	}
   
   /**Calculates preferred width for JFrame, adds Link Menu if table contains a Home Page column, 
   Makes the table, & shows it in a JFrame. */
   public void makeTableEtc(Object[][] Data, Object [] ColumnNames){
            p = new JPanel(new BorderLayout());
            
            CustomModel Model = new CustomModel(Data, ColumnNames);
            
            JTable resultTable = new JTable(Model);
            
            URLRenderer urlRenderer = new URLRenderer();
             
                try{resultTable.setDefaultRenderer(Class.forName("java.net.URL"), urlRenderer);}
               catch(Exception e) {query_text.append("\nP in URLRenderer: " + e);}

            int PrefWidthFrame = 0;
            for (int i=0; i<resultTable.getColumnCount(); i++){
                
                String ColumnName = resultTable.getModel().getColumnName(i);
                
                if (ColumnName.toUpperCase().equals("HOMEPAGE"))
                    {addLinkMenu();}
                    
                TableColumn Col = resultTable.getColumn(ColumnName);
                
                int PrefWidthCol = Model.getColPrefWidth(resultTable,i);
                Col.setMinWidth(PrefWidthCol);
                PrefWidthFrame += PrefWidthCol;
            }
            p.add(new JScrollPane(resultTable), "Center");
            
            f = new JFrame();
            f.getContentPane().add(p);
            
            f.setTitle("Query Results Table");
            PrefWidthFrame += 15;
            int PrefHeightFrame = 200;
            f.setBounds(400, 250, PrefWidthFrame, PrefHeightFrame);
            f.show();}
    
	/** Runs Thread which Queries Server. If the call to the server's 
    *	query method returned no errors in the Return object,
	*   a Table is Created with the Query Results
	*   and displayed in a Frame; Otherwise the errors are printed one
	*   by one to the Text Area. [There is currently no reason to thread
	*   the QueryApplet but it has been done for the sake of possible 
	*   future extensions using animation--and to say we did ;)]*/
	public void run(){
               Return Returned = null;
               status.setText("Querying Database...");
               try{ Returned = QInterface.query((String)toSend);
                }
                   catch (Exception e){
                        status.setText("Problem in QInterface.query: " + e.toString());}
              Vector SnitchResults = Returned.getErs();
              if (SnitchResults.isEmpty()){
                  Object [][] Data = Returned.getData();
                  Object [] ColumnNames = Returned.getColumnNames();
                  String ColumnName;
                  for (int i = 0; i< ColumnNames.length; i++){
                    ColumnName = ((String)ColumnNames[i]).toUpperCase();
                    boolean IsHomePage = ColumnName.equals("HOMEPAGE");
                    boolean IsTitle = ColumnName.equals("TITLE");
                    if ( IsHomePage | IsTitle ){
                        for (int j = 0; j< Data.length; j++){
                            String s = (String)Data[j][i];
                            if (IsHomePage){
                            if (s != null){
                                //take out double quotes..
                                s = s.substring(1, s.length()-1);
                                try{URL HomePage = new URL(s);
                                Data[j][i] = HomePage;
                                }
                                catch (Exception e){query_text.append("\n URL exception: " + e);
                                }}}
                    }
                 makeTableEtc(Data, ColumnNames);
                    }
                  }
              }
              else {
                  while (!SnitchResults.isEmpty())
                   {query_text.setText("");
                    query_text.append("  " + SnitchResults.elementAt(0)+ "; ");
                     SnitchResults.removeElementAt(0);
                   }
                 status.setText("Sorry.");
              }

         }
  
}
    




