//implementation class
import java.rmi.*;
import java.rmi.server.UnicastRemoteObject;
import java.rmi.registry.*;
import java.io.*;
import java.awt.*;
import java.awt.event.*;
import java.util.*;
import html_author.*;
import html_title.*;
import plsql.*;
import SQLWrapper;
import com.sun.java.swing.table.*;
import com.sun.java.swing.*;
import com.sun.java.swing.event.*;
import com.sun.java.swing.preview.*;

/** The Server */
public class QueryServer
	extends UnicastRemoteObject
	implements QueryInterface

{
	private String name;

    public QueryServer(String s) throws RemoteException {
		super();
		name = s;
		
	}

/** Returns Client's Saved Queries. Server looks for a text file with the cookie name
	    from a hardcoded directory, currently: "c:\Inetpub\wwwroot\PubTest\ClientQueries",
	    Character tag '\u0001' used to separate queries (so that \n may be preserved
	    in the orignial queries)*/
	public Vector getSavedList (String cookie) throws RemoteException{
	    Vector queries = new Vector();

	    File ClientFile = new File("c:\\Inetpub\\wwwroot\\PubTest\\ClientQueries\\", cookie + ".txt");
	    int c;
	    FileInputStream file = null;
	    InputStreamReader InReader = null;
	    BufferedReader bInReader = null;
	    try{ file = new FileInputStream(ClientFile);
	         InReader = new InputStreamReader(file);
	         bInReader = new BufferedReader(InReader);
	    }
	    catch(Exception e){System.out.println("File I/O Err: " + e);}
	    try{ String temp = new String();
	        while ((c = bInReader.read()) != -1)
	            {  char ch = (char)c;
	                if (ch != '\u0001')
	                temp += ch;
	                else
                    {queries.addElement(temp);
                     temp = "";}
	            }
	         file.close();
	    }
	    catch(Exception e){System.out.println("File read er: " + e);}
        return queries;
    }
    
    /** Saves SQL string to Client's Saved Query file. Text file is written to or 
    created in a hardcoded directory, currently: c:\Inetpub\wwwroot\PubTest\ClientQueries
    named with the cookie String. The end of queries are marked with the character tag
    '\u0001'*/
	public String saveToList (String cookie, String newSQL) throws RemoteException{
	    String FileName = "c:\\Inetpub\\wwwroot\\PubTest\\ClientQueries\\" + cookie + ".txt";
	    FileWriter Fwriter = null;
	    BufferedWriter Bwriter = null;
	    try{ Fwriter = new FileWriter(FileName, true);
	         Bwriter = new BufferedWriter(Fwriter);
	         Bwriter.write(newSQL, 0, newSQL.length());
	         Bwriter.write("\u0001",0,1);
	         Bwriter.flush();
	    }
	    catch(Exception e){System.out.println("File write er: " + e);
	                       return "Couldn't save to list..";}

	    return "Query Saved.";
	    }
    
    /** ReWrites the Client's Saved Query file from a Vector of "Spared queries". 
     (Basically saveToList but adds more than one query and rewrites rather than appends 
     to the file)*/
	public String deleteFunction (String cookie, Vector SparedItems) throws RemoteException{
	    String FileName = "c:\\Inetpub\\wwwroot\\PubTest\\ClientQueries\\" + cookie + ".txt";
	    FileWriter Fwriter = null;
	    BufferedWriter Bwriter = null;
	    try{ Fwriter = new FileWriter(FileName, false);
	         Bwriter = new BufferedWriter(Fwriter);
	         for (int i=0; i<SparedItems.size(); i++){
	         Bwriter.write((String)(SparedItems.elementAt(i)), 0, ((String)(SparedItems.elementAt(i))).length());
	         Bwriter.write("\u0001",0,1);
	         }
	         Bwriter.flush();
	        
	    }
	    catch(Exception e){System.out.println("File write er: " + e);
	                       return "Couldn't save to list..";}

	    return "Deleted from list.";
	    }

    /** The Main Functionality; Effecting the Query. Creates an instance of SQLWrapper which it uses to Query the database. 
    Adds multiple tables from the WebSite to the Oracle database (sendSQL), 
    Queries the Oracle database (queryDB), and Creates a Table Model from the returned 
    data. The SQLWrapper's ErrorSnitch is emptied, and those (possible) errors are
    returned with the Table Model to the client in the Return object.*/
	synchronized public Return query(String SQLp)throws RemoteException{
        String SQL = new String(SQLp);
        SQLWrapper wrapper = new SQLWrapper();
        Vector result = null;
        Object[][] QueryData = null;
        Object[] QueryColumns = null;
        DefaultTableModel QueryTable = null;
        Vector Errors = null;
        Return toReturn;
        try {
            result = wrapper.sendSQL(SQL);}
            catch (Exception e) {
                 System.err.println(e);
             }
                    
                    
        System.out.println("Querying Database");
        if (result!=null){
            try{ QueryData = wrapper.queryDB(SQL);}
                catch (Exception e){
                    System.err.println(e);}

            System.out.println("Creating Table");
            if (QueryData!=null) {
                    
                 try{ 
                    
                     
                     QueryColumns = wrapper.getAttNames();
            }
                    catch (Exception e){
                        System.err.println(e);}
                 }
        }
       Errors = wrapper.getSnitchErrors();
       toReturn = new Return(QueryData, QueryColumns, Errors);
       return toReturn;
}

/** Writes necessary RMI code. Creates a registry on port 1099, binds the QueryServer and ErrorSnitch objects 
    to the registry with the names "QueryServer" and "ErrorSnitch", and sets a 
    Security Manager*/
	public static void main(String args[])
	{
	Registry reg;
    System.setSecurityManager(new RMISecurityManager());
    QueryServer Server = null;
    try
    {
      reg = LocateRegistry.createRegistry(1099);
      Server = new QueryServer("QueryServer");
      reg.rebind("QueryServer", Server);
	  String [] registered = reg.list();
	  for (int i=0; i< registered.length; i++)
	    System.out.println("" + registered[i] + " is bound in registry");
    }
    catch (Exception e)
    {
      System.out.println("Server Error: " + e);
    }
    }

    }

