import plsql.*;
import html_title.*;
import html_author.*;
import java.util.*;
import java.io.*;
import java.net.*;
import java.sql.*;

/** This is the actual wrapper. The other files are just for the GUI.
 */

public class SQLWrapper {

    private boolean connected=false;

    private final static boolean DEBUG = false;

    /**
     *  the DB driver
     */
    public Class driver;
    /**
     * the DB connection
     */
    public java.sql.Connection connection = null;


    /** a nasty hack for passing the attribute names to a GUI. We're
     *   not using JavaCC correctly - one should generate a tree with
     *   JJTree and the iterate through the tree. I'm just filling a
     *   vector with the strings that are output by the parser(s) and
     *   parse this vector again. */
    String[] attNames = null;

    Vector mySnitch = new Vector();

    /**
     *  Constructor. Creates Database connection only. Assumes
     *  Oracle-DB-Driver in the classpath (classes111.zip) */

    public SQLWrapper () {

        System.out.println("This is the Wrapper in D:\\Projects");
        
        String url = "jdbc:oracle:thin:@shiba.wpi.edu:1521:ORCL";
        String className = new String("oracle.jdbc.driver.OracleDriver");
        // db driver
        String user = new String("cs561");
        String passwd = new String("cs561");
       
        try{
            driver = Class.forName(className);
            connection = java.sql.DriverManager.getConnection(url, user, passwd);
            System.out.println("Connected\n");
            connected = true;
        }
        catch (Exception exc) {
            mySnitch.addElement("DB Exception: " + exc.toString());
            
            System.out.println("DB Exception");
            return;
        }
        
	    }

    /** Accepts an SQL-statement and sends a number of queries to the
     * Web-site.  the parser is instantiated multiple times.
     * @param s The query statement.
     * @return return vector doesn't mean anything
     */
    public Vector sendSQL(String s) {
        Vector result=null;
        StringReader inp = new StringReader(s);
        FormsPlSql p = new FormsPlSql(inp) ;

        // before we're trying a new query, we flush the Oracle database
        try {
            Statement flush = connection.createStatement();

            flush.executeUpdate("delete from author");
            flush.executeUpdate("delete from article");
            flush.executeUpdate("delete from rel");
            flush.close();
        }
        catch (SQLException exc) {
            mySnitch.addElement("SQL Exception in sendSQL : " + exc.toString());
           
            System.out.println("SQL Exception in sendSQL : " + exc.toString());
        }


        try {
            // compile the SQL statement
            p.CompilationUnit() ; // in the process of
            // compiling... puts token list to system.out, just for debugging

            // now go through the vector that we received
            Enumeration e = p.result.elements();
            String entry,keyword;
            DataInputStream in, freshStream;
            while (e.hasMoreElements()) {
                // hack: I search only for "SUBMIT"-tokens from the
                // parser.  if they're followed by "name", I send to
                // "author" form, otherwise "article" form.  I get a
                // datainputstream back for each. Has to be sent to
                // HTML-parser then.  This means that we do not
                // support empty quries (no keyword) to the DBLP
                // site. Wouldn't be very useful anyway.
                entry = (String)e.nextElement();
                System.out.println("Entry:"+entry+":");
                if (entry.startsWith("SUBMIT")) {
                    // a bad hack removes quotes and spaces... a first
                    // attempt at pattern matching "translation"
                    keyword = entry.substring(entry.indexOf("=")+1)
                        .replace('\'',' ')
                        .replace('%',' ') // simulating ORACLE-like-queries
                        .trim();
                    System.out.println("Searching for "+keyword);
                    // assumption: when searching for "author", "name"
                    // keyword is always used, for "article" searches,
                    // we always use "title" keyword.
                    if (entry.indexOf("name") !=-1) {
                        in = searchAuthor(keyword);
                        if(in.markSupported())
                            {System.out.println("Mark supported");
                            in.mark(100000);}
                            else
                            System.out.println("Mark not supported!");
                            
                        Vector URLStreams = parseList.getURLStreams(in);
                        
                        System.out.println("URLStreams: " + URLStreams);
                        if (URLStreams != null)
                            {for (int i = 0; i<URLStreams.size(); i++)
                                result = parseAuthorHTML((DataInputStream)URLStreams.elementAt(i));
                            }
                        else
                            {in.reset();
                            result = parseAuthorHTML(in);}
                    }
                    else {
                        if (entry.indexOf("title") !=-1) {
                            in = searchArticle(keyword);
                            result = parseArticleHTML(in);
                        }
                    }
                    // else do nothing.
                }
            }
        } catch (Exception exc) {
          mySnitch.addElement("SQL Parse error!");
                mySnitch.addElement(exc.getMessage());
         
            System.out.println("SQL Parse error!");
            System.out.println(exc.getMessage());
        }
        return result;
    }



    /** Accepts a keyword for the author search form and returns
     * HTML-code from the query result on a DataInputStream */
    public DataInputStream searchAuthor (String s) {
  DataInputStream in = null;
  // read a search string from the command line if given
            String searchString= new String(s);
  // open the URL to the author web page (URL is in the Page
            // Source of that page on the web)
        try {
        URL authorForm = new URL("http://www.informatik.uni-trier.de/~ley/dbbin/author");
 // open connection and use it for HTTP-output
            URLConnection connection = authorForm.openConnection();
            connection.setDoOutput(true);
    // send the "author"-Field
            PrintWriter out =
                new PrintWriter(connection.getOutputStream());
            out.print("author=" + URLEncoder.encode(searchString));
            out.close();
            System.out.println("Query sent...waiting for results.");
    // receive feedback
            in = new DataInputStream (connection.getInputStream());
        }
        catch (Exception e) {System.out.println(e);}
      return in;
    }

    /** Accepts a keyword for the article search form and returns
     * HTML-code from the query result on a DataInputStream. Except
     * for different URL and keyword, same as "searchAuthor" <BR> Here
     * is some room for improvement for a more general solution. */

    public DataInputStream searchArticle (String s) {

        DataInputStream in = null;
        try {

            String searchString= new String(s);

            URL titleForm =
                new URL("http://www.informatik.uni-trier.de/~ley/dbbin/title");

            URLConnection connection = titleForm.openConnection();
            connection.setDoOutput(true);

            PrintWriter out =
                new PrintWriter(connection.getOutputStream());
            out.print("title=" + URLEncoder.encode(searchString));
            out.close();

            in =
                new DataInputStream (connection.getInputStream());
        }
        catch (Exception e) {}

        return in;
    }


    /** currently returns the exact parser output as a vector of strings */
    Vector parseAuthorHTML(DataInputStream in)  {

        html_author.html32 t = new html_author.html32(in);
        System.out.println("Retrieving data for one author");
        System.out.println("t.result: " + t.result);
        try {
            html_author.SimpleNode n = t.html();
        } catch (Exception e) {
            mySnitch.addElement("HTML Parse error!");
            mySnitch.addElement(e.getMessage());
           
            System.out.println("HTML Parse error!");
            System.out.println(e.getMessage());
            return null;
        }

        if (DEBUG) System.out.println("Storing articles");
        // trying to store articles
        
        storeArticles(t.result);

        return t.result;
    }

    /** currently returns the exact parser output as a vector of strings */
    Vector parseArticleHTML(DataInputStream in)  {

        html_title.html32 t = new html_title.html32(in);

        try {
            html_title.SimpleNode n = t.html();
        } catch (Exception e) {
            mySnitch.addElement("HTML Parse error!");
                 mySnitch.addElement(e.getMessage());
            
            System.out.println("HTML Parse error!");
            System.out.println(e.getMessage());
            return null;
    }

        if (DEBUG) System.out.println("Storing articles");
        // trying to store articles
       
        
        storeArticles(t.result);

        return t.result;
    }


    /** takes a vector according to the HTML-parser (hardcoded
     *  keywords!!!) and stores it in a relational DB. This is a
     *  single-thread algorithm, parallel execution won't work (thus
     *  no applet on the web :) ) */
  void storeArticles (Vector data) {
    
        PreparedStatement stmt1=null, stmt2=null, stmt3=null, query=null;
        ResultSet rs = null;
        boolean result = false;
        Vector tempAuthors= new Vector(); // Vector of Strings, for authors

        try {

            // insert an author and assign an id
            stmt1 =
                connection.prepareStatement ( "insert into author values"+
                                              " (s_author.nextval,?, ?)");
            // insert an article and assign an id
            stmt2 = 
                connection.prepareStatement( "insert into article values"+
                                             " (s_article.nextval,?,?,?)");

            // insert a relationship and search for author by name
            // must immediately follow the insert-title statement we
            // assume non-parallel processing!!! this code is not
            // parallel-safe!
            stmt3 = 
                connection.prepareStatement( "insert into rel" +
                                             " (select author_id, s_article.currval"+
                                             " from author where name = ?)");

            query = 
                connection.prepareStatement( "select count(*) from author"+
                                             " where name = ?");


            Enumeration e = data.elements();
            String line,value,publications,pages, mainAuth="", homePage="";
            while (e.hasMoreElements()) {
                line = (String)e.nextElement();
                value = line.substring(line.indexOf(":")+1); // after :
                if (DEBUG) System.out.println(line);
	
	            if (line.startsWith("mainAuth:")) {
                    mainAuth = value;
                    System.out.println("mainAuth: " + mainAuth);
                }
                if (line.startsWith("homePage:")) {
                    homePage = value;
                    System.out.println("Got the homePage: " + homePage);
                }
                
                if (line.startsWith("author:")) {
                   
                    tempAuthors.addElement(value);
                    query.setString(1,value);
                    rs = query.executeQuery();
                    rs.next(); 
                    if (rs.getInt(1)==0) { 
                        //value doesn't exist
                        stmt1.setString(1,value);
                        if ((value.equals(mainAuth)) && !(homePage.equals("")))
                            stmt1.setString(2, homePage);
                        else stmt1.setString(2, null);
                        stmt1.executeUpdate ();
                    }
                }
                // we assume that after title there is ALWAYS a field
                // publication and maybe a field page !!! If there is
                // no page, we comsume the "newline" token which is
                // otherwise just not read. (complies with our current
                // (050399) HTML grammar)
                if (line.startsWith("title:")) {
                    publications = (String)e.nextElement();
                    publications =
                        publications.substring(publications.indexOf(":")+1);
                    pages = (String)e.nextElement();
                    if (!pages.startsWith("page:")) pages = ""; 
                    else pages = 
                             pages.substring(pages.indexOf(":")+1);
                    // if there is no page-tag, consume the newline tag
                    stmt2.setString(1,value);
                    stmt2.setString(2,publications);
                    stmt2.setString(3,pages);
                    stmt2.executeUpdate();
                    for (int i = 0 ; i < tempAuthors.size() ; i++ ) {
                        stmt3.setString(1,(String)tempAuthors.elementAt(i));
                        stmt3.executeUpdate();
                        // this may break under parallel execution!
                    }
                    tempAuthors.removeAllElements();
                }
            } // end of while-loop. Newline-tags are ignored.

            result = true;
            stmt1.close(); stmt2.close(); stmt3.close(); query.close();
        }
        // we should have a finer-grain exception handling here and
        // then make the execution threadsafe. Later.
        catch (java.sql.SQLException exc) {
            System.out.println("SQL Exception in wrapper call: " 
                               + exc.toString());
        }
    
    } 
    

    /**
     *
     * Returns an array to be used by the swing JTable class<BR> partly
     * stolen from EVE-Demo<BR> expects SQL in the dialect the DB
     * understands.<BR>
     *
     *
     * @author koeller (05/03/1999) */


    public Object[][] queryDB(String SQL) {

	PreparedStatement stmt = null;
	Statement count=null;
        ResultSet rs = null;
        ResultSetMetaData rsmt = null;

        String s=null,countsql;
        int row,cutindex,no_of_tuples,colCount;

	Object[][]data = null;

	SQL=SQL.replace(';',' ')
            .replace('\n',' ')
            .trim(); // don't be so sensitive for
        // semicolons and \n

        try {
            if (DEBUG) System.out.println("queryDB: SQL is: " + SQL);
            if(connection == null)
                mySnitch.addElement("Debug: queryDB: DB connection is null!");
                //mySnitch.reportError("Debug: queryDB: DB connection is null!");
                System.err.println("Debug: queryDB: DB connection is null!");

            stmt =  connection.prepareStatement (SQL);
	    count = connection.createStatement();

	    // wrap SQL with "count(*)"-statement. this breaks Oracle
	    // queries if they contain "order by" clauses. No fix yet,
	    // but the fix is straightforward.
	    countsql = "select count(*) from ("+SQL+")";
	    if (DEBUG) System.out.println("counting tuples with "+countsql);

	    rs = count.executeQuery(countsql);
	    if (rs.next()) no_of_tuples = rs.getInt(1);
	    else return null; // if query didn't work.

	    if (DEBUG) System.out.println(no_of_tuples +" tuples!!!");
	    if (no_of_tuples==0) return null; // no result from the query

            rs = stmt.executeQuery ();
            rsmt = rs.getMetaData();
	    colCount = rsmt.getColumnCount();
	    attNames = new String[colCount];
	    for (int i=0; i<colCount; i++)
		attNames[i]=rsmt.getColumnName(i+1);  // JSQL index shift :(

	    row = 0;

            // declare an array just as big as needed.
	    data = new Object[no_of_tuples][colCount];
	    if (DEBUG) System.out.println("Create table :" + colCount +
                                          " by "+no_of_tuples);
	    while (rs.next()) {
		for (int i=0; i<rsmt.getColumnCount(); i++) {
                    data[row][i]=rs.getString(i+1); // JSQL index shift :(
		}
		row++;
            }
            rs.close ();
            stmt.close ();
        }
        catch (SQLException exc) {
            mySnitch.addElement("SQL Exception in queryDB : "
                               + exc.toString());
        
            System.out.println("SQL Exception in queryDB : "
                               + exc.toString());
        }catch (Exception e){
           mySnitch.addElement("Debug: queryDB: Non-SQL-Error:"
                               + e.getMessage());
          
            System.out.println("Debug: queryDB: Non-SQL-Error:"
                               + e.getMessage());
            e.printStackTrace();
        }
        
        return data;
    }

    /** this is a bad hack, since we need to pass two data structures
     *   to the relationFrame class and I didn't want to write a new
     *   class for that */
    public String[] getAttNames() {
	return attNames;
    }
    
    public Vector getSnitchErrors(){
        return mySnitch;
    }

}
